/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy;

import edu.princeton.swing.PTextField;
import edu.princeton.toy.lang.TWord;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class TBaseConverterPane
extends JPanel {
    public static final Font DEFAULT_FONT = new Font("Dialog", 0, 12);
    private Document binaryDocument;
    private Document decimalDocument;
    private Document hexDocument;
    private Document pseudoCodeDocument;
    private boolean ignoreBinaryDocument;
    private boolean ignoreDecimalDocument;
    private boolean ignoreHexDocument;
    private Listener listener;

    public TBaseConverterPane() {
        this(TWord.ZERO);
    }

    public TBaseConverterPane(TWord initialValue) {
        super(new GridBagLayout(), true);
        if (initialValue == null) {
            throw new NullPointerException();
        }
        this.setFont(DEFAULT_FONT);
        this.add((Component)new JLabel("Base Converter"), new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)new JLabel("Binary"), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)new JLabel("Decimal"), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)new JLabel("Hexadecimal"), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)new JLabel("Pseudocode"), new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.listener = new Listener();
        PTextField textField = new PTextField(17);
        textField.setFont(null);
        this.binaryDocument = textField.getDocument();
        this.binaryDocument.addDocumentListener(this.listener);
        this.add((Component)textField, new GridBagConstraints(1, 1, 1, 1, 5.0, 1.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
        textField = new PTextField(17);
        textField.setFont(null);
        this.decimalDocument = textField.getDocument();
        this.decimalDocument.addDocumentListener(this.listener);
        this.add((Component)textField, new GridBagConstraints(1, 2, 1, 1, 5.0, 1.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
        textField = new PTextField(17);
        textField.setFont(null);
        this.hexDocument = textField.getDocument();
        this.hexDocument.addDocumentListener(this.listener);
        this.add((Component)textField, new GridBagConstraints(1, 3, 1, 1, 5.0, 1.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
        textField = new PTextField(17);
        textField.setFont(null);
        textField.setEditable(false);
        this.pseudoCodeDocument = textField.getDocument();
        this.add((Component)textField, new GridBagConstraints(1, 4, 1, 1, 5.0, 1.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.setValue(initialValue, null);
    }

    public void setValue(TWord value) {
        this.setValue(value, null);
    }

    protected void setValue(TWord value, Document source) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (source != this.binaryDocument) {
            this.ignoreBinaryDocument = true;
            try {
                this.binaryDocument.remove(0, this.binaryDocument.getLength());
                if (value.isInitialized()) {
                    this.binaryDocument.insertString(0, value.toBinaryString(false), null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.ignoreBinaryDocument = false;
        }
        if (source != this.decimalDocument) {
            this.ignoreDecimalDocument = true;
            try {
                this.decimalDocument.remove(0, this.decimalDocument.getLength());
                if (value.isInitialized()) {
                    this.decimalDocument.insertString(0, String.valueOf(value.getValue()), null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.ignoreDecimalDocument = false;
        }
        if (source != this.hexDocument) {
            this.ignoreHexDocument = true;
            try {
                this.hexDocument.remove(0, this.hexDocument.getLength());
                if (value.isInitialized()) {
                    this.hexDocument.insertString(0, value.toHexString(false), null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.ignoreHexDocument = false;
        }
        try {
            this.pseudoCodeDocument.remove(0, this.pseudoCodeDocument.getLength());
            if (value.isInitialized()) {
                this.pseudoCodeDocument.insertString(0, value.toPseudoCodeString(false), null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void documentChanged(Document source) {
        if (source == this.binaryDocument) {
            if (!this.ignoreBinaryDocument) {
                try {
                    this.setValue(TWord.parseWord(this.binaryDocument.getText(0, this.binaryDocument.getLength()), 2), this.binaryDocument);
                }
                catch (NumberFormatException e) {
                    this.setValue(TWord.UNINITIALIZED_VALUE, this.binaryDocument);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.setValue(TWord.UNINITIALIZED_VALUE, this.binaryDocument);
                }
            }
        } else if (source == this.decimalDocument) {
            if (!this.ignoreDecimalDocument) {
                try {
                    this.setValue(TWord.parseWord(this.decimalDocument.getText(0, this.decimalDocument.getLength()), 10), this.decimalDocument);
                }
                catch (NumberFormatException e) {
                    this.setValue(TWord.UNINITIALIZED_VALUE, this.decimalDocument);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.setValue(TWord.UNINITIALIZED_VALUE, this.decimalDocument);
                }
            }
        } else if (source == this.hexDocument) {
            if (!this.ignoreHexDocument) {
                try {
                    this.setValue(TWord.parseWord(this.hexDocument.getText(0, this.hexDocument.getLength()), 16), this.hexDocument);
                }
                catch (NumberFormatException e) {
                    this.setValue(TWord.UNINITIALIZED_VALUE, this.hexDocument);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.setValue(TWord.UNINITIALIZED_VALUE, this.hexDocument);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected class Listener
    implements DocumentListener {
        protected Listener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            TBaseConverterPane.this.documentChanged(e.getDocument());
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            TBaseConverterPane.this.documentChanged(e.getDocument());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            TBaseConverterPane.this.documentChanged(e.getDocument());
        }
    }
}

